import { StyleSheet, Dimensions } from "react-native";
import dpr from "../../Utilities/CustomStyleAttribute/dpr";

const { height } = Dimensions.get("window");

export const OnboardStyle = StyleSheet.create({
    indicatorContainer: {
        display: "flex",
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "flex-end",
        backgroundColor: "#fff",
        height: dpr(40),
    },
    indicator: {
        height: 5,
        width: 27,
        backgroundColor: "#DFDFDF",
        borderRadius: 42,
        marginHorizontal: 3,
    },
    activeIndicator: {
        backgroundColor: "#FCCA19",
        width: dpr(55),
    },
    nextBtn: {
        height: dpr(60),
        width: dpr(65),
        borderRadius: dpr(16),
        backgroundColor: "#FCCA19",
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    getStart: {
        width: dpr("wf") - dpr(40),
        height: dpr(60),
        backgroundColor: "#FCCA19",
        borderRadius: dpr(6),
        flexDirection: "row",
        justifyContent: "center",
        alignItems: "center",
    },
    getStartText: {
        fontFamily: "DMSans_700Bold",
        fontSize: dpr(20),
        lineHeight: dpr(25),
        color: "#2C2C2C",
    },
});
